<?php
/**
 * Add widget products to elementor
 *
 * @since   1.6.2
 * @package Claue
 */
 
class Claue_Elementor_Instagram_Widget extends \Elementor\Widget_Base {
    
    /**
	 * Get widget name.
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'claue-instagram';
	}

	/**
	 * Get widget title.
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Instagram', 'claue' );
	}

	/**
	 * Get widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-archive-posts';
	}
    
    /**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return array( 'instagram' );
	}

	/**
	 * Get widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return array( 'claue-elements' );
	}

	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 */
	protected function _register_controls() {
	   
       /////////////////////

	    $this->start_controls_section(
			'claue_addons_instagram',
			array(
				'label' => __( 'Content', 'claue' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

        $this->add_control(
            'user_id',
            array(
                'label' => esc_html__( 'User ID', 'claue' ),
                'description' => sprintf( wp_kses_post( 'Lookup User ID <a target="_blank" href="%s">here</a>', 'claue' ), 'https://codeofaninja.com/tools/find-instagram-user-id' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '',
            )
        );

        $this->add_control(
            'username',
            array(
                'label' => esc_html__( 'Username', 'claue' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '',
            )
        );

        $this->add_control(
            'link',
            array(
                'label' => esc_html__( 'Link to Instagram', 'claue' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '',
            )
        );

        $this->add_control(
            'access_token',
            array(
                'label' => esc_html__( 'Access Token', 'claue' ),
                'description' => sprintf( wp_kses_post( 'Lookup Access Token <a target="_blank" href="%s">here</a>', 'claue' ), 'http://instagram.pixelunion.net/' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '',
            )
        );

		$this->add_control(
			'limit',
			array(
				'label' => esc_html__( 'Per Page', 'claue' ),
                'description' => esc_html__( 'How much items per page to show', 'claue' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => '',
                'default' => '12',
			)
		);

        $this->add_control(
            'columns',
            array(
                'label' => esc_html__( 'Columns', 'claue' ),
                'description' => esc_html__( 'This parameter will not working if slider has enabled', 'claue' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    '2' => esc_html__( '2 Columns', 'claue' ),
                    '3' => esc_html__( '3 Columns', 'claue' ),
                    '4' => esc_html__( '4 Columns', 'claue' ),
                    '5' => esc_html__( '5 Columns', 'claue' ),
                    '6' => esc_html__( '6 Columns', 'claue' ),
                    '7' => esc_html__( '7 Columns', 'claue' ),
                    '8' => esc_html__( '8 Columns', 'claue' ),
                    '9' => esc_html__( '9 Columns', 'claue' ),
                    '10' => esc_html__( '10 Columns', 'claue' ),
                ),
                'default' => '3',
            )
        );

        $this->add_control(
            'size',
            array(
                'label' => esc_html__( 'Image size', 'claue' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'thumbnail' => esc_html__( '150x150', 'claue' ),
                    'low' => esc_html__( '320x320', 'claue' ),
                    'standard' => esc_html__( '640x640', 'claue' ),
                ),
                'default' => 'low',
            )
        );

        $this->add_control(
            'gutter',
            array(
                'label' => esc_html__( 'Gutter Width', 'claue' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => '',
            )
        );

        ///////////////////
        
        $this->add_control(
			'slider',
			array(
				'label' => esc_html__( 'Enable Slider', 'claue' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_off' => esc_html__( 'No', 'claue' ),
				'label_on' => esc_html__( 'Yes', 'claue' ),
				'separator' => 'before',
                'default' => '',
			)
		);
        
        $this->add_control(
			'items',
			array(
				'label' => esc_html__( 'Items (Number only)', 'claue' ),
                'description' => esc_html__( 'Set the maximum amount of items displayed at a time with the widest browser width', 'claue' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 4,
			)
		);
        
        $this->add_control(
			'autoplay',
			array(
				'label' => esc_html__( 'Enable Auto play', 'claue' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_off' => esc_html__( 'No', 'claue' ),
				'label_on' => esc_html__( 'Yes', 'claue' ),
                'default' => '',
			)
		);
        
        $this->add_control(
			'arrows',
			array(
				'label' => esc_html__( 'Enable Navigation', 'claue' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_off' => esc_html__( 'No', 'claue' ),
				'label_on' => esc_html__( 'Yes', 'claue' ),
                'default' => '',
			)
		);
				
		$this->add_control(
			'dots',
			array(
				'label' => esc_html__( 'Enable Pagination', 'claue' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_off' => esc_html__( 'No', 'claue' ),
				'label_on' => esc_html__( 'Yes', 'claue' ),
				'separator' => 'after',
                'default' => '',
			)
		);
        
        ///////////////////
        
        $this->add_control(
			'class',
			array(
				'label' => esc_html__( 'Extra class name', 'claue' ),
                'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'claue' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => '',
			)
		);

		$this->end_controls_section();

	}
    
    /**
     * Create shortcode row
	 * 
	 * @return string
	 */
	public function create_shortcode() {

		$settings = $this->get_settings_for_display();
        
        $args_row = '';
        
        $args_row .= $settings['slider'] == 'yes' ? ' slider="true"' : '';
        $args_row .= $settings['items'] ? ' items="'.absint($settings['items']).'"' : '';
        $args_row .= $settings['autoplay'] == 'yes' ? ' autoplay="true"' : '';
        $args_row .= $settings['arrows'] == 'yes' ? ' arrows="true"' : '';
        $args_row .= $settings['dots'] == 'yes' ? ' dots="true"' : '';
        
        $args_row .= $settings['user_id'] ? ' user_id="'.esc_attr($settings['user_id']).'"' : '';
        $args_row .= $settings['username'] ? ' username="'.esc_attr($settings['username']).'"' : '';
        $args_row .= $settings['link'] ? ' link="'.esc_attr($settings['link']).'"' : '';
        $args_row .= $settings['access_token'] ? ' access_token="'.esc_attr($settings['access_token']).'"' : '';
        $args_row .= $settings['size'] ? ' size="'.esc_attr($settings['size']).'"' : '';
        $args_row .= $settings['gutter'] ? ' gutter="'.esc_attr($settings['gutter']).'"' : '';
        
        ///////////////////////
        
        $args_row .= $settings['columns'] ? ' columns="'.esc_attr($settings['columns']).'"' : '';
        
        $args_row .= absint($settings['limit']) ? ' limit="'.absint($settings['limit']).'"' : '';
        
        $args_row .= $settings['class'] ? ' class="'.esc_attr($settings['class']).'"' : '';
        
       // error_log('$settings: '.print_r($settings, 1));
        
        return '[claue_addons_instagram'.$args_row.']';

	}

	/**
	 * Render widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 */
	protected function render() {

		echo do_shortcode( $this->create_shortcode() );
        
        if ( is_admin() ){
          echo "
         <script>
          if ( jQuery( '.jas-carousel' ).length > 0 ){
            jQuery( '.jas-carousel' ).not('.slick-initialized').slick({focusOnSelect: true});
          }
         </script>";
        }
        
        return;

	}
    
    /**
	 * Render widget as plain content.
	 *
	 * Override the default behavior by printing the shortcode instead of rendering it.
	 *
	 * @since 1.0.0
	 * @access public
	 */
	 public function render_plain_content() {
	   
		// In plain mode, render without shortcode
		echo $this->create_shortcode();
        
	 }

}
/////////////////////
